* This file does the primary analysis of the WVS microdata
global controls "age1-age4 fage1-fage4 sex sex_missing age_missing"
set matsize 2000
clear
set mem 1200m
*** Table 1
use "Processed files\WVS" if nonrepresentative==0, clear

* No controls
bys wave: oprobit sat lgdp [pw=wt1000], robust cluster(cty)
xi: oprobit sat lgdp i.wave [pw=wt1000], robust cluster(cty)
xi: oprobit sat lgdp i.wave [pw=wt1000] if nonrepresentative==0, robust cluster(cty)
bys wave: oprobit hap lgdp [pw=wt1000], cluster(cty)
xi: oprobit hap lgdp i.wave [pw=wt1000], cluster(cty)

* With controls
bys wave: oprobit sat lgdp $controls [pw=wt1000], robust cluster(cty)
xi: oprobit sat lgdp $controls i.wave [pw=wt1000], robust cluster(cty)
xi: oprobit sat lgdp $controls i.wave [pw=wt1000] if nonrepresentative==0, robust cluster(cty)
bys wave: oprobit hap lgdp $controls [pw=wt1000], cluster(cty)
xi: oprobit hap lgdp $controls i.wave [pw=wt1000], cluster(cty)


*** Table 2
use "Processed files\WVS" if nonrepresentative==0, clear
gen educ=x025
drop cty
gen cty=s003a /* Household income is consistently coded by i.s003a*i.wave, not by cty*/
egen ctywave=group(cty wave)
xi i.cty, prefix(c_) 
xi i.cty*i.wave, prefix(cw_) 

* No controls
bys wave: oprobit sat lninc c_* [pw=wt1000], robust nolog
oprobit sat lninc cw_* [pw=wt1000], robust nolog

bys wave: oprobit hap lninc c_* [pw=wt1000], robust nolog
oprobit hap lninc cw_* [pw=wt1000], robust nolog

* Controls
bys wave: oprobit sat lninc $controls c_* [pw=wt1000], robust nolog
oprobit sat lninc $controls cw_* [pw=wt1000], robust nolog

bys wave: oprobit hap lninc $controls c_* [pw=wt1000], robust nolog
oprobit hap lninc $controls cw_* [pw=wt1000], robust nolog

* IV
levelsof wave if educ~=., local(waves)
foreach w of local waves  {
	xi: reg lninc i.cty*i.educ $controls [pw=wt1000] if wave==`w' & sat~=.
	predict lninc_hat if lninc~=. & educ~=. & cty~=. & sat~=. & wave==`w' 
	predict lninc_res if lninc~=. & educ~=. & cty~=. & sat~=. & wave==`w', res	
	xi: oprobit sat lninc_hat lninc_res $controls i.cty if wave==`w' [pw=wt1000], robust nolog
	drop lninc_hat lninc_res
}
xi: reg lninc  i.educ*i.ctywave $controls [pw=wt1000] if sat~=.
predict lninc_hat if lninc~=. & educ~=. & cty~=. & sat~=.
predict lninc_res if lninc~=. & educ~=. & cty~=. & sat~=. , res	
xi: oprobit sat lninc_hat lninc_res $controls i.ctywave [pw=wt1000], robust nolog
drop lninc_hat lninc_res

levelsof wave if educ~=., local(waves)
foreach w of local waves {
	xi: reg lninc i.cty*i.educ $controls [pw=wt1000] if wave==`w' & hap~=.
	predict lninc_hat if lninc~=. & educ~=. & cty~=. & hap~=. & wave==`w'
	predict lninc_res if lninc~=. & educ~=. & cty~=. & hap~=. & wave==`w', res	
	xi: oprobit hap lninc_hat lninc_res $controls i.cty if wave==`w' [pw=wt1000], robust nolog
	drop lninc_hat lninc_res
}
xi: reg lninc  i.educ*i.ctywave $controls [pw=wt1000] if hap~=.
predict lninc_hat if lninc~=. & educ~=. & cty~=. & hap~=. 
predict lninc_res if lninc~=. & educ~=. & cty~=. & hap~=. , res	
xi: oprobit hap lninc_hat lninc_res $controls i.ctywave [pw=wt1000], robust nolog
drop lninc_hat lninc_res


*** Table 3
use "Processed files\WVS" if nonrepresentative==0, clear
oprobit sat  lgdp [pw=wt1000], cluster(cty)
xi: oprobit sat lgdp i.cty [pw=wt1000], cluster(cty)
xi: oprobit sat lgdp i.cty i.wave [pw=wt1000], cluster(cty)
egen minwv_sat=min(wave) if sat~=. & lgdp~=., by(cty)
egen maxwv_sat=max(wave) if sat~=. & lgdp~=., by(cty)
xi: oprobit sat lgdp i.cty i.wave if (wave==minwv | wave==maxwv) & (maxwv~=minwv) [pw=wt1000], cluster(cty)
drop minwv maxwv

oprobit hap  lgdp [pw=wt1000], cluster(cty)
xi: oprobit hap lgdp i.cty [pw=wt1000], cluster(cty)
xi: oprobit hap lgdp i.cty i.wave [pw=wt1000], cluster(cty)
egen minwv_hap=min(wave) if hap~=. & lgdp~=., by(cty)
egen maxwv_hap=max(wave) if hap~=. & lgdp~=., by(cty)
xi: oprobit hap lgdp i.cty i.wave if (wave==minwv | wave==maxwv) & (maxwv~=minwv) [pw=wt1000], cluster(cty)
drop minwv maxwv


*** Table 6: Bradburn Affect Scale
* Bradburn net affect scale
use "Processed files\WVS" if nonrepresentative==0, clear

xi i.ctywve
foreach v of varlist feeling_pleased feeling_proud feeling_excited feeling_topof feeling_goingmyway feeling_bored feeling_upset feeling_restless feeling_lonely feeling_depressed  {
	reg `v' if lgdp~=. [pw=wt]
	probit `v' lgdp $controls [pw=wt], cluster(cty)
	probit `v' lninc $controls _I* [pw=wt]
}
gen positive=feeling_pleased+feeling_proud+feeling_excited+feeling_topof+feeling_goingmyway
gen negative=feeling_bored+feeling_upset+feeling_restless+feeling_lonely+feeling_depressed  
gen netaffect=positive-negative
foreach v of varlist positive negative netaffect {
	reg `v' lgdp $controls [pw=wt], cluster(cty)
	summ `v' [w=wt] if lgdp~=.
	reg `v' lninc $controls _I* [pw=wt]
	summ `v' [w=wt] if lninc~=.
}


*** Figure 12: Within versus between slopes
use "Processed files\WVS", clear
keep if wave==2000
* Estimate country-level averages
xi: oprobit sat i.ctywve [pw=wt]
predict sat_hat if sat~=., xb
egen tag=tag(ctywve)
for X in var sat_hat: summ X if tag==1 \ replace X=X-r(mean)

* Estimating within-country slopes
gen str8 ctywave=cty+"_"+string(year)
gen temp=sat+lninc
gen b_sat=.
levelsof s024a, local(ctywaves)
foreach c of local ctywaves {
	qui summ temp if s024a==`c'
	if r(N)>0 {
		oprobit sat lninc $controls if s024a==`c' [pw=wt], robust
		replace b_sat=_b[lninc] if s024a==`c'
	}
}
drop temp

gen ylow=exp(lgdp-.25) if b_sat~=.
gen yhigh=exp(lgdp+.25) if b_sat~=.
gen satlow=sat_hat-b_sat*.25
gen sathigh=sat_hat+b_sat*.25

oprobit sat lgdp 
reg sat_hat lgdp if tag==1
predict sat_hat_fit if sat~=. & lgdp~=.

#delimit ;
twoway
	(scatter sat_hat gdp if nonrepresentative==0, mlabel(cty) mlabpos(6) mcolor(navy) msymbol(circle) mlabcolor(navy))
	(scatter sat_hat gdp if nonrepresentative!=0, mlabel(cty) mlabpos(6) mcolor(black) msymbol(square_hollow) mlabcolor(black))
	(pcarrow satlow ylow sathigh yhigh, lcolor(black) mcolor(black))
	(line sat_hat_fit gdp, sort lpattern(longdash) lcolor(gray))
	if tag==1 & wave==2000
,
	xscale(log)
	xlabel( 500 ".5" 1000 "1"   2000 "2" 4000 "4" 8000 "8" 16000 "16" 32000 "32") 
	xtitle("Real GDP per capita (thousands of dollars, log scale)", size(small))
	ytitle("Life satisfaction (ordered probit index)", size(small))
	ylabel(-1.5(.5)1, angle(horizontal) format(%9.1f))
	legend( order(1 "Country aggregates" 3 "Within-country wellbeing gradient" 4 "Between-country wellbeing gradient")
		  rowgap(tiny) margin(tiny) bmargin(tiny)
	 	  size(small)
		  rows(3) pos(11) ring(0))
	xsize(10) ysize(7.5)
	name(sat_micromacro, replace)
;
#delimit cr
graph save "Figures/fig12.gph", replace


*** Assessment of question order effects
use "Processed files\WVS" if nonrep==0, clear
egen t_ctywve=tag(cty wave)
* Find a consistent set of nations
egen cty_obs=sum(t_ctywve), by(cty)
gen perm=cty_obs==4
* Assess effects of finsat on sat and hap
gen finsat=c006
summ finsat sat if perm==1 [w=wt]
bys wave: correl finsat sat hap if perm==1 [w=wt]
* Assess effects of importance questions on sat and hap
bys wave: correl a001 sat hap if perm==1 [w=wt]
bys wave: correl a002 sat hap if perm==1 [w=wt]
bys wave: correl a003 sat hap if perm==1 [w=wt]
bys wave: correl a004 sat hap if perm==1 [w=wt]
bys wave: correl a005 sat hap if perm==1 [w=wt]
bys wave: correl a006 sat hap if perm==1 [w=wt]



